

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>API Documentation - MyAuthenticator</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            display: flex;
        }
        .sidebar {
            width: 250px;
            position: fixed;
            height: 100vh;
            background: #343a40;
            color: white;
            padding-top: 20px;
        }
        .sidebar a {
            padding: 10px 20px;
            display: block;
            color: white;
            text-decoration: none;
        }
        .sidebar a:hover {
            background: #007bff;
        }
        .content {
            margin-left: 260px;
            padding: 20px;
            width: 100%;
        }
        pre {
            background: #f8f9fa;
            padding: 10px;
            border-radius: 5px;
        }
        .try-it-container {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
        }
    </style>
</head>
<body>

<!-- Sidebar -->
<div class="d-flex">
    <div class="bg-light p-3" style="width: 250px; min-height: 100vh;">
        <h4>API Documentation</h4>
        <ul class="nav flex-column">
            <li class="nav-item"><a class="nav-link" href="../dashboard.php">Dashbaord</a></li>
            <li class="nav-item"><a class="nav-link" href="#register-app">Register App</a></li>
            <li class="nav-item"><a class="nav-link" href="#generate-qr">Generate QR Code</a></li>
            <li class="nav-item"><a class="nav-link" href="#validate-otp">Validate OTP</a></li>
            <li class="nav-item"><a class="nav-link" href="#manage-keys">Manage API Keys</a></li>
        </ul>
    </div>
    <div class="p-4 w-100">
        <div id="api-content">
            <!-- API documentation content here -->
        </div>
    </div>
</div>




<!-- Main Content -->
<div class="content">
    <h1 class="text-center mb-4">MyAuthenticator API Documentation</h1>

    <div class="alert alert-info">
        This API allows external developers to integrate <strong>MyAuthenticator</strong> as a Two-Factor Authentication (2FA) service.
    </div>

    <!-- Generate QR Code Section -->
    <div id="generate_qr" class="card mb-4">
        <div class="card-header bg-primary text-white">📌 Generate QR Code</div>
        <div class="card-body">
            <p><strong>Endpoint:</strong> <code>/api/generate_qr.php</code></p>
            <p><strong>Method:</strong> <code>POST</code></p>
            <p><strong>Try It Now:</strong></p>
            <div class="try-it-container">
                <label>App Name:</label>
                <input type="text" id="app_name" class="form-control mb-2" placeholder="Enter App Name">
                <label>User ID:</label>
                <input type="text" id="user_id" class="form-control mb-2" placeholder="Enter User ID">
                <button class="btn btn-primary w-100" onclick="tryGenerateQR()">Try Now</button>
                <pre id="generate_qr_response"></pre>
            </div>
        </div>
    </div>

    <!-- Validate OTP Section -->
    <div id="validate_otp" class="card mb-4">
        <div class="card-header bg-success text-white">✅ Validate OTP</div>
        <div class="card-body">
            <p><strong>Endpoint:</strong> <code>/api/validate_otp.php</code></p>
            <p><strong>Method:</strong> <code>POST</code></p>
            <p><strong>Try It Now:</strong></p>
            <div class="try-it-container">
                <label>User ID:</label>
                <input type="text" id="otp_user_id" class="form-control mb-2" placeholder="Enter User ID">
                <label>OTP:</label>
                <input type="text" id="otp_code" class="form-control mb-2" placeholder="Enter OTP">
                <button class="btn btn-success w-100" onclick="tryValidateOTP()">Try Now</button>
                <pre id="validate_otp_response"></pre>
            </div>
        </div>
    </div>

    <!-- List Scanned QR Codes -->
    <div id="list_qr" class="card mb-4">
        <div class="card-header bg-warning text-white">🔍 List Scanned QR Codes</div>
        <div class="card-body">
            <p><strong>Endpoint:</strong> <code>/api/list_scanned_qr.php</code></p>
            <p><strong>Method:</strong> <code>GET</code></p>
            <p><strong>Try It Now:</strong></p>
            <div class="try-it-container">
                <button class="btn btn-warning w-100" onclick="tryListScannedQR()">Try Now</button>
                <pre id="list_qr_response"></pre>
            </div>
        </div>
    </div>




    <h4>🔹 Enter App Name</h4>
<input type="text" id="appNameInput" class="form-control mb-2" placeholder="Enter your app name">

<button class="btn btn-primary" onclick="tryGenerateQR()">Try It Now</button>

<h4>🔹 Response Output</h4>
<pre id="qrResponse" class="bg-light p-3 border"></pre>


<div class="card">
    <div class="card-header">Register App</div>
    <div class="card-body">
        <input type="text" id="appNameInput" class="form-control mb-2" placeholder="Enter App Name">
        <button class="btn btn-primary" onclick="tryRegisterApp()">Try It Now</button>
        <pre id="registerResponse" class="mt-3 p-3 bg-light"></pre>
    </div>
</div>


<div class="card">
    <div class="card-header">Validate OTP</div>
    <div class="card-body">
        <input type="text" id="otpInput" class="form-control mb-2" placeholder="Enter OTP">
        <button class="btn btn-primary" onclick="tryValidateOTP()">Try It Now</button>
        <pre id="otpResponse" class="mt-3 p-3 bg-light"></pre>
    </div>
</div>






</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


<script>
function tryValidateOTP() {
    let otp = document.getElementById("otpInput").value;
    if (!otp) {
        alert("Please enter an OTP.");
        return;
    }

    fetch('/api/validate_otp.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'API-Key': 'your_api_key_here'
        },
        body: JSON.stringify({ otp: otp })
    })
    .then(response => response.json())
    .then(data => {
        document.getElementById("otpResponse").textContent = JSON.stringify(data, null, 2);
    })
    .catch(error => {
        document.getElementById("otpResponse").textContent = "Error: " + error;
    });
}
</script>


<script>
function tryRegisterApp() {
    let appName = document.getElementById("appNameInput").value;
    if (!appName) {
        alert("Please enter an app name.");
        return;
    }

    fetch('/api/register_app.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ app_name: appName })
    })
    .then(response => response.json())
    .then(data => {
        document.getElementById("registerResponse").textContent = JSON.stringify(data, null, 2);
    })
    .catch(error => {
        document.getElementById("registerResponse").textContent = "Error: " + error;
    });
}
</script>

<script>
function tryGenerateQR() {
    const appName = document.getElementById("appNameInput").value.trim(); // Get app name

    if (!appName) {
        document.getElementById("qrResponse").textContent = "Error: App name is required!";
        return;
    }

    fetch('/api/generate_qr.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'API-Key': 'your_api_key_here'
        },
        body: JSON.stringify({ app_name: appName }) // Use user's input
    })
    .then(response => response.json())
    .then(data => {
        document.getElementById("qrResponse").textContent = JSON.stringify(data, null, 2);
    })
    .catch(error => {
        document.getElementById("qrResponse").textContent = "Error: " + error;
    });
}
</script>


<script>
    function tryGenerateQR() {
        let app_name = document.getElementById("app_name").value;
        let user_id = document.getElementById("user_id").value;

        fetch('/api/generate_qr.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ app_name, user_id })
        })
        .then(response => response.json())
        .then(data => {
            document.getElementById("generate_qr_response").textContent = JSON.stringify(data, null, 2);
        })
        .catch(error => {
            document.getElementById("generate_qr_response").textContent = "Error: " + error;
        });
    }

    function tryValidateOTP() {
        let user_id = document.getElementById("otp_user_id").value;
        let otp = document.getElementById("otp_code").value;

        fetch('/api/validate_otp.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ user_id, otp })
        })
        .then(response => response.json())
        .then(data => {
            document.getElementById("validate_otp_response").textContent = JSON.stringify(data, null, 2);
        })
        .catch(error => {
            document.getElementById("validate_otp_response").textContent = "Error: " + error;
        });
    }

    function tryListScannedQR() {
        fetch('/api/list_scanned_qr.php')
        .then(response => response.json())
        .then(data => {
            document.getElementById("list_qr_response").textContent = JSON.stringify(data, null, 2);
        })
        .catch(error => {
            document.getElementById("list_qr_response").textContent = "Error: " + error;
        });
    }
</script>

</body>
</html>
