<?php
require '../db_config.php'; // Database connection

function authenticate() {
    if (!isset($_SERVER['HTTP_API_KEY'])) {
        http_response_code(401);
        echo json_encode(["error" => "API key is required"]);
        exit;
    }

    $api_key = $_SERVER['HTTP_API_KEY'];
    $stmt = $pdo->prepare("SELECT id FROM users WHERE api_key = ?");
    $stmt->execute([$api_key]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        http_response_code(403);
        echo json_encode(["error" => "Invalid API key"]);
        exit;
    }

    return $user['id'];
}
?>
