<?php

/*

include 'header.php'; ?>

<h2 class="mb-4">Welcome to Your Dashboard</h2>

<?php
if (isset($_SESSION['flash_message'])) {
    echo '<div class="alert alert-success">' . $_SESSION['flash_message'] . '</div>';
    unset($_SESSION['flash_message']);
}
?>


<div class="row">
    <div class="col-md-4">
        <a href="generate_qr.php" class="btn btn-primary w-100 mb-3">Generate OTP</a>
    </div>
    <div class="col-md-4">
        <a href="validate_otp.php" class="btn btn-warning w-100 mb-3">Validate OTP</a>
    </div>
    <div class="col-md-4">
        <a href="scan_qr.php" class="btn btn-info w-100 mb-3">Scan QR</a>
    </div>
</div>

<?php include 'footer.php'; ?>
*/

include 'header.php';
//session_start();
include 'db.php';

// Fetch the user's QR code path from the database
$user_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT qr_code_path FROM authentications WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();

$qrCodePath = $row['qr_code_path'] ?? null;




$stmt->close();
$conn->close();



?>

<h2>Your QR Code <?= $_SESSION['user_id']; ?></h2>

<?php if ($qrCodePath): ?>
    <p>Here is your QR Code:</p>
    <img src="<?php echo $qrCodePath; ?>" alt="QR Code" class="img-fluid">
<?php else: ?>
    <p>You haven't generated a QR code yet. Please generate one first.</p>
<?php endif; ?>



<h2 class="mb-4">Welcome to Your Dashboard</h2>

<?php
if (isset($_SESSION['flash_message'])) {
    echo '<div class="alert alert-success">' . $_SESSION['flash_message'] . '</div>';
    unset($_SESSION['flash_message']);
}
?>

<div class="row">
    <div class="col-md-4">
        <a href="generate_qr.php" class="btn btn-primary w-100 mb-3">Generate OTP</a>
    </div>
    <div class="col-md-4">
        <a href="validate_otp.php" class="btn btn-warning w-100 mb-3">Validate OTP</a>
    </div>
    <div class="col-md-4">
        <a href="scan_qr.php" class="btn btn-info w-100 mb-3">Scan QR</a>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <a href="view_qr.php" class="btn btn-success w-100 mb-3">View Your QR Code</a>
    </div>
</div>

<?php include 'footer.php'; ?>
