<?php
session_start();
require 'db_config.php'; // Database connection

// Check if user is already logged in
if (isset($_SESSION['user_id'])) {
    header("Location: dashboard.php");
    exit();
}

$message = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);
    $remember = isset($_POST['remember']);

    $stmt = $pdo->prepare("SELECT id, email, password FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_email'] = $user['email'];

        if ($remember) {
            setcookie('user_id', $user['id'], time() + (86400 * 30), "/"); // 30 days
        }

        header("Location: dashboard.php");
        exit();
    } else {
        $message = "Invalid email or password.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | IamGrey Authenticator</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background: linear-gradient(to right, #1e3c72, #2a5298); /* Cool blue gradient */
            color: #fff;
            min-height: 100vh;
        }
        .card {
            background-color: #ffffff;
            color: #000;
            border-radius: 12px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
        }
        .logo {
            width: 150px;
            height: auto;
            display: block;
            margin: 0 auto 20px;
        }
        #offlineAlert {
            display: none;
        }
    </style>
</head>
<body>
    <!-- Internet status alert -->
    <div class="container mt-3">
        <div id="offlineAlert" class="alert alert-danger text-center" role="alert">
            ⚠️ No internet connection! Please check your network.
        </div>
    </div>

    <!-- Login form -->
    <div class="container">
        <div class="row justify-content-center mt-5">
            <div class="col-md-5">
                <div class="card p-4">
                    <div class="card-body">
                        <img src="images/authenticator-logo.png" alt="IamGrey-Authenticator" class="logo">
                        <h4 class="text-center mb-4">Login</h4>

                        <?php if ($message): ?>
                            <div class="alert alert-danger"><?= $message ?></div>
                        <?php endif; ?>

                        <form method="POST" id="loginForm">
                            <div class="form-group">
                                <label>Email</label>
                                <input type="email" name="email" class="form-control" required>
                            </div>
                            <div class="form-group">
                                <label>Password</label>
                                <input type="password" name="password" class="form-control" required>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" name="remember" class="form-check-input">
                                <label class="form-check-label">Remember Me</label>
                            </div>
                            <button type="submit" class="btn btn-primary btn-block mt-3" id="submitBtn">Login</button>
                        </form>

                        <p class="text-center mt-3">Don't have an account? <a href="register.php">Register</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JS to detect internet connection -->
    <script>
        function updateInternetStatus() {
            const alertBox = document.getElementById("offlineAlert");
            const submitBtn = document.getElementById("submitBtn");

            if (navigator.onLine) {
                alertBox.style.display = "none";
                submitBtn.disabled = false;
            } else {
                alertBox.style.display = "block";
                submitBtn.disabled = true;
            }
        }

        // Check on page load and whenever status changes
        window.addEventListener('load', updateInternetStatus);
        window.addEventListener('online', updateInternetStatus);
        window.addEventListener('offline', updateInternetStatus);
    </script>
</body>
</html>
