<?php
require "../config.php";
require "verify_token.php";

header("Content-Type: application/json");

$user_id = verifyToken(); // Get user ID from JWT

try {
    $stmt = $conn->prepare("SELECT id, app_name, secret_key FROM user_qr_codes WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $qr_codes = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(["status" => "success", "qr_codes" => $qr_codes]);
} catch (Exception $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
?>
