<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Scan QR Code</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script src="https://unpkg.com/html5-qrcode"></script>
    <style>
        .navbar-toggler {
            border: none;
        }
        .navbar-toggler:focus {
            box-shadow: none;
        }
        #qr-reader {
            width: 100%;
            max-width: 350px;
            margin: auto;
            border: 2px solid #007bff;
            border-radius: 10px;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container-fluid">
            <a class="navbar-brand" href="#">iamGrey-Authenticator</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item"><a class="nav-link" href="#">Dashboard</a></li>
                    <li class="nav-item"><a class="nav-link" href="#">Validate OTP</a></li>
                    <li class="nav-item"><a class="nav-link active" href="#">Scan QR</a></li>
                    <li class="nav-item"><a class="nav-link" href="#">Generate OTP</a></li>
                    <li class="nav-item"><a class="nav-link" href="#">Manage API Keys</a></li>
                    <li class="nav-item"><a class="nav-link" href="#">API Docs</a></li>
                    <li class="nav-item"><a class="nav-link text-danger" href="#">Logout</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container mt-4 text-center">
        <h2 class="mb-3">Scan QR Code</h2>
        <p>Scan a QR code from another application to generate OTPs.</p>
        <p id="qr-result" class="mt-3 alert alert-info d-none"></p>

        <form id="save-secret-form" action="save_scanned_qr.php" method="POST" class="mt-3 d-none">
            <label for="app_name">Enter App Name:</label>
            <input type="text" id="scanned_qr" name="app_name" required class="form-control mb-2">
            <label for="scanned-secret">Secret Key:</label>
            <input type="text" id="scanned-secret" name="secret" class="form-control mb-2" required>
            <button type="submit" class="btn btn-success">Save Scanned QR</button>
        </form>

        <div id="qr-reader" class="mt-4"></div>
    </div>

    <script>
        function onScanSuccess(decodedText) {
            let secretMatch = decodedText.match(/secret=([^&]+)/);
            let secret = secretMatch ? secretMatch[1] : null;

            if (!secret) {
                alert("❌ Error: Could not extract secret from QR Code!");
                return;
            }

            document.getElementById('qr-result').textContent = "✅ QR Code Scanned!";
            document.getElementById('qr-result').classList.remove('d-none');
            document.getElementById('scanned-secret').value = secret;
            document.getElementById('save-secret-form').classList.remove('d-none');
        }

        function onScanFailure(error) {
            console.warn("QR Scan Error: ", error);
        }

        const qrScanner = new Html5Qrcode("qr-reader");
        qrScanner.start(
            { facingMode: "environment" },
            { fps: 10, qrbox: { width: 250, height: 250 } },
            onScanSuccess,
            onScanFailure
        );
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
