<?php
require 'vendor/autoload.php';

use chillerlan\QRCode\QRCode;
use chillerlan\QRCode\QROptions;

// Ensure the 'qrcodes' directory exists
$qrcodeDir = 'qrcodes/';
if (!is_dir($qrcodeDir)) {
    mkdir($qrcodeDir, 0777, true);
}

// Define test QR data (Change this to your actual QR data)
$testData = "https://example.com/test";

// Generate QR code image
$options = new QROptions([
    'outputType' => QRCode::OUTPUT_IMAGE_PNG, // Ensure it's a PNG format
    'eccLevel'   => QRCode::ECC_H, // High error correction
    'scale'      => 10, // Size of the QR code
]);

$qrCode = new QRCode($options);
$qrCodePath = $qrcodeDir . 'test_qr.png';
$qrCode->render($testData, $qrCodePath); // Save QR code as a file

// Check if the file was created successfully
if (file_exists($qrCodePath)) {
    echo "✅ QR Code generated successfully!<br>";
    echo "<img src='$qrCodePath' alt='Test QR Code'>";
} else {
    echo "❌ Failed to generate QR Code.";
}
?>
